package com.ejie.ab04b.dao;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TareaErronea;

/**
 * TareaErroneaDaoImpl generated by UDA, 13-dic-2017 13:03:55.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class TareaErroneaDaoImpl implements TareaErroneaDao {
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the TareaErronea table.
	 *
	 * @param TareaErronea
	 *            TareaErronea
	 * @return TareaErronea
	 */
	public TareaErronea add(TareaErronea TareaErronea) {
		String query = "INSERT INTO AB0443T00 (MAILBOX_TASK_ID_043, TASK_TYPE_ID_043) VALUES (?,?)";
		this.jdbcTemplate.update(query, TareaErronea.getMailboxTaskId43(),
				TareaErronea.getTaskTypeId043());
		return TareaErronea;
	}

	/**
	 * Removes a single row in the TareaErronea table.
	 *
	 * @param TareaErronea
	 *            TareaErronea
	 * @return
	 */
	public void remove(TareaErronea TareaErronea) {
		String query = "DELETE FROM AB0443T00 WHERE MAILBOX_TASK_ID_043=?";
		this.jdbcTemplate.update(query, TareaErronea.getMailboxTaskId43());
	}

}
